#include <amxmodx>
#include <amxmisc>
#include <worms>
#include <fakemeta>

#define PLUGIN "Worms weapon template"
#define AUTHOR "Monyak"


// CLUSTER GRENADE
#define CLUSTER_COST 1000
#define CLUSTER_COUNT 5

#define CLUSTER_FRAGMENTS 5
#define CLUSTER -15
new const g_ClusterModel[3][] = {
	"models/worms/weapons/v_cluster.mdl",
	"models/worms/weapons/p_cluster.mdl",
	"models/worms/weapons/w_cluster.mdl"
}
new weapon_cluster,cvar_cluster_damage



public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_forward(FM_PlayerPreThink,"FM_PlayerPreThink_Hook")
	register_forward(FM_Touch, "FM_Touch_Hook")
	register_forward(FM_Think, "FM_Think_Hook")
	
	
	weapon_cluster = worms_register_weapon("Frag Grenade",WEAPON_GRENADE,CLUSTER_COUNT,CLUSTER_COST)
	cvar_cluster_damage = register_cvar("worms_frag_damage","30.0")
}

public plugin_precache()
{
	for(new i=0;i<3;i++)
	{
		precache_model(g_ClusterModel[i])
	}
}



public worms_weapon_selected(id,weaponid)
{
	if(is_user_alive(id) && worms_get_allowfire(id) > 0)
	{
		if(weaponid == weapon_cluster)
			ClusterSelected(id)
			
	}
}

public FM_PlayerPreThink_Hook(id)
{
	if(!is_user_alive(id))
		return FMRES_IGNORED
	new button = pev(id,pev_button)
	if(worms_get_active_weapon(id) == weapon_cluster)
	{
		// check buttons and do some things(see worms_weapons for example)
	}
	return FMRES_IGNORED
}
public FM_Touch_Hook(ent1,ent2)
{
	new ent,n
	ent = TouchCheck(n,ent1,ent2) // get "main" entity from two
	if(!n) // if no worms entities was found
		return FMRES_IGNORED
	if(pev_valid(ent))
	{
		new class = pev(ent,pev_weaponclass)
		if(class == weapon_cluster)
		{
			// make bounce or explosion
		}			
	}
	return FMRES_IGNORED
}
public FM_Think_Hook(ent)
{
	if(!pev_valid(ent))
		return FMRES_IGNORED
	if(pev(ent,pev_worms) != WORMS_WEAPON)
		return FMRES_IGNORED
	new class = pev(ent,pev_weaponclass)	
	
	// do some things, if bullet needs
	
	return FMRES_IGNORED
}


// CLUSTER
public ClusterSelected(id)
{
	if(!is_user_alive(id))
		return
	worms_set_active_weapon(id,weapon_cluster)
	
	// change models, ...
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/
